/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.lang;

import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.x2d.lang.X2DError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class X2DSchemaErrorHandler
implements ErrorHandler {
    private List<X2DError> errors = new ArrayList<X2DError>();

    public List<X2DError> getErrors() {
        return this.errors;
    }

    public int countError() {
        return this.errors.size();
    }

    public boolean hasErrors() {
        return this.countError() > 0;
    }

    private void recordError(SAXParseException exception) {
        X2DError error = new X2DError();
        error.setColumnNumber(exception.getColumnNumber());
        error.setLineNumber(exception.getLineNumber());
        if (exception.getCause() != null) {
            error.setMessage(exception.getMessage() + " with cause :" + exception.getCause().getMessage());
        } else {
            error.setMessage(exception.getMessage());
        }
        if (exception.getException() != null) {
            error.setMessage(exception.getMessage() + " with exception :" + exception.getException().getMessage());
        } else {
            error.setMessage(exception.getMessage());
        }
        error.setPublicId(exception.getPublicId());
        error.setSystemId(exception.getSystemId());
        this.errors.add(error);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.recordError(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.recordError(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.recordError(exception);
    }
}

