/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYTable;
import de.javasoft.swing.jytable.renderer.CellLayoutHint;
import de.javasoft.swing.jytable.renderer.DefaultTableHeaderRenderer;
import de.javasoft.swing.jytable.renderer.TableHeaderCellProvider;
import de.javasoft.swing.jytable.renderer.TableRegion;
import de.javasoft.swing.plaf.addons.JYTableHeaderAddon;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.StringValues;

public class JYTableHeader
extends JXTableHeader {
    private static final Logger LOG = Logger.getLogger(JYTableHeader.class.getName());
    public static final String uiClassID = "JYTableHeaderUI";
    private boolean subHeader;
    private CellLayoutHint cellLayoutHint;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYTableHeaderAddon());
    }

    public JYTableHeader() {
        this(null);
    }

    public JYTableHeader(TableColumnModel columnModel) {
        super(columnModel);
    }

    public JYTable getXTable() {
        if (!(this.getTable() instanceof JYTable)) {
            return null;
        }
        return (JYTable)((Object)this.getTable());
    }

    protected void installHeaderListener() {
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new DefaultTableHeaderRenderer.DefaultTableHeaderRendererUI();
    }

    public void setCellLayoutHint(CellLayoutHint hint) {
        CellLayoutHint old = this.getCellLayoutHint();
        this.cellLayoutHint = hint;
        this.updateRendererLayout();
        this.firePropertyChange("cellLayoutHint", old, this.getCellLayoutHint());
        this.revalidate();
        this.repaint();
    }

    protected void updateRendererLayout() {
        if (this.getCellLayoutHint() == null) {
            return;
        }
        ComponentProvider<?> provider = this.getComponentProvider();
        if (provider instanceof TableHeaderCellProvider) {
            TableHeaderCellProvider cellProvider = (TableHeaderCellProvider)provider;
            cellProvider.setSortMarkerPosition(this.getCellLayoutHint().sortMarkerPosition);
            cellProvider.setHorizontalAlignment(this.getCellLayoutHint().horizontalAlignment);
            cellProvider.setVerticalAlignment(this.getCellLayoutHint().verticalAlignment);
        }
    }

    public CellLayoutHint getCellLayoutHint() {
        return this.cellLayoutHint;
    }

    public Component getLayoutComponent(Object constraint) {
        if (this.getLayout() instanceof TableHeaderCellComponentLayout) {
            return ((TableHeaderCellComponentLayout)this.getLayout()).getLayoutComponent(constraint);
        }
        return null;
    }

    public int getPreferredLayoutWidth(Object constraint) {
        if (this.getLayout() instanceof TableHeaderCellComponentLayout) {
            return ((TableHeaderCellComponentLayout)this.getLayout()).getPreferredLayoutWidth((JTableHeader)((Object)this), constraint);
        }
        return -1;
    }

    public void setSubHeader(boolean subheader) {
        if (this.subHeader == subheader) {
            return;
        }
        this.subHeader = subheader;
        this.setLayout(this.isSubHeader() ? new TableHeaderCellComponentLayout() : null);
        this.updateSubHeaderState();
        this.firePropertyChange("subHeader", !subheader, this.isSubHeader());
    }

    public boolean isSubHeader() {
        return this.subHeader;
    }

    protected void updateSubHeaderState() {
        if (this.getComponentProvider() == null) {
            return;
        }
        if (this.getComponentProvider().getStringValue() instanceof UIResource) {
            if (this.isSubHeader()) {
                this.getComponentProvider().setStringValue(StringValues.EMPTY_UI);
            } else {
                this.getComponentProvider().setStringValue(null);
            }
        }
        ((DefaultTableHeaderRenderer)this.getDefaultRenderer()).setTableRegion(this.isSubHeader() ? TableRegion.TABLE_SUBHEADER : TableRegion.TABLE_HEADER);
    }

    protected ComponentProvider<?> getComponentProvider() {
        if (this.getDefaultRenderer() instanceof DefaultTableHeaderRenderer) {
            return ((DefaultTableHeaderRenderer)this.getDefaultRenderer()).getComponentProvider();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        int i = this.getComponentCount() - 1;
        while (i >= 0) {
            this.getComponent(i).setEnabled(enabled);
            --i;
        }
        super.setEnabled(enabled);
    }

    public JPopupMenu getComponentPopupMenu() {
        if (this.isEnabled()) {
            return super.getComponentPopupMenu();
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        LayoutManager layout = this.getLayout();
        if (layout != null) {
            size.height = layout.preferredLayoutSize((Container)((Object)this)).height;
        }
        return size;
    }

    public void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        if (this.getDraggedColumn() != null || e.getFromIndex() != e.getToIndex()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setDraggedColumn(TableColumn column) {
        if (this.getDraggedColumn() == column) {
            return;
        }
        super.setDraggedColumn(column);
        if (column == null) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        super.updateUI();
        if (this.getDefaultRenderer() instanceof UIDependent) {
            ((UIDependent)this.getDefaultRenderer()).updateUI();
        }
        this.updateRendererLayout();
        this.updateSubHeaderState();
    }

    public static final class TableHeaderCellComponentLayout
    implements LayoutManager2,
    Serializable {
        private Insets margin;
        private Insets fallback = new Insets(1, 1, 1, 1);
        private final Map<Component, Integer> components = new HashMap<Component, Integer>();
        private final Map<Integer, Component> constraints = new HashMap<Integer, Component>();

        public Insets getMargin(JTableHeader th) {
            Border border;
            if (this.margin != null) {
                return this.margin;
            }
            TableCellRenderer renderer = th.getDefaultRenderer();
            Component comp = renderer.getTableCellRendererComponent(th.getTable(), null, false, false, -1, -1);
            if (comp instanceof JComponent && (border = ((JComponent)comp).getBorder()) != null) {
                return SyntheticaLookAndFeel.getInsets((String)"JYTable.subHeader.cell.insets", (Component)th, (Insets)border.getBorderInsets(th));
            }
            return this.fallback;
        }

        public Component getLayoutComponent(Object constraint) {
            if (constraint instanceof Integer) {
                return this.constraints.get(constraint);
            }
            return null;
        }

        public int getPreferredLayoutWidth(JTableHeader header, Object constraint) {
            Component comp = this.getLayoutComponent(constraint);
            if (comp == null) {
                return -1;
            }
            Insets margin = this.getMargin(header);
            int width = comp.getPreferredSize().width + margin.left + margin.right;
            return width;
        }

        public void setMargin(Insets m) {
            if (m == null) {
                throw new IllegalArgumentException("margin not allowed null");
            }
            this.margin = new Insets(m.top, m.left, m.bottom, m.right);
        }

        @Override
        public void layoutContainer(Container parent) {
            JTableHeader th = (JTableHeader)parent;
            JTable table = th.getTable();
            int componentCount = th.getComponentCount();
            int i = 0;
            while (i < componentCount) {
                int viewIndex;
                int colIndex;
                Component comp = th.getComponent(i);
                Integer columnIndexObj = this.components.get(comp);
                if (table == null || columnIndexObj == null || (colIndex = columnIndexObj.intValue()) < 0 || (viewIndex = table.convertColumnIndexToView(colIndex)) < 0 || viewIndex >= table.getColumnCount()) {
                    comp.setBounds(0, 0, 0, 0);
                } else {
                    Rectangle rect = th.getHeaderRect(viewIndex);
                    TableColumn draggedColumn = th.getDraggedColumn();
                    if (draggedColumn != null && draggedColumn.getModelIndex() == colIndex) {
                        rect.x += th.getDraggedDistance();
                        th.setComponentZOrder(comp, 0);
                    }
                    Insets margin = this.getMargin(th);
                    rect.x += margin.left;
                    rect.y += margin.top;
                    rect.width -= margin.left + margin.right;
                    rect.height -= margin.top + margin.bottom;
                    Dimension size = comp.getPreferredSize();
                    if (rect.height > size.height) {
                        rect.y += (rect.height - size.height) / 2;
                        rect.height = size.height;
                    }
                    comp.setBounds(rect);
                }
                ++i;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JTableHeader th = (JTableHeader)parent;
            JTable table = th.getTable();
            int componentCount = th.getComponentCount();
            int h = 0;
            int i = 0;
            while (i < componentCount) {
                int viewIndex;
                int colIndex;
                Component comp = th.getComponent(i);
                Integer columnIndexObj = this.components.get(comp);
                if (table != null && columnIndexObj != null && (colIndex = columnIndexObj.intValue()) >= 0 && (viewIndex = table.convertColumnIndexToView(colIndex)) >= 0 && viewIndex < table.getColumnCount()) {
                    h = Math.max(h, comp.getPreferredSize().height);
                }
                ++i;
            }
            Insets margin = this.getMargin(th);
            return new Dimension(0, margin.top + margin.bottom + h);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            Integer constraint = this.components.remove(comp);
            this.constraints.remove(constraint);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraint) {
            if (!(constraint instanceof Integer)) {
                return;
            }
            this.components.put(comp, (Integer)constraint);
            this.constraints.put((Integer)constraint, comp);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

