/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.FocusManager;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.basic.ComboPopup;

class ExtKeyEventProcessor
implements KeyEventPostProcessor {
    private static boolean altKeyPressed = false;
    private static boolean menuActivated = false;
    private static boolean winKeyArmed = false;

    ExtKeyEventProcessor() {
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        if (keyEvent.isConsumed()) {
            return false;
        }
        this.winMetaKeySupport(keyEvent);
        if (!ExtKeyEventProcessor.activateMenuByAltKey()) {
            return false;
        }
        int n = keyEvent.getModifiersEx();
        boolean bl2 = (n & 0x80) == 128;
        boolean bl3 = bl = (n & 0x2000) == 8192;
        if (keyEvent.getKeyCode() == 18 && !bl2 && !bl) {
            JMenuBar jMenuBar;
            Component component = keyEvent.getComponent();
            Window window = SwingUtilities.getWindowAncestor(component);
            JRootPane jRootPane = SwingUtilities.getRootPane(component);
            JMenuBar jMenuBar2 = jMenuBar = jRootPane != null ? jRootPane.getJMenuBar() : null;
            if (jMenuBar == null && window instanceof JFrame) {
                jMenuBar = ((JFrame)window).getJMenuBar();
            }
            if (keyEvent.getID() == 401) {
                if (!altKeyPressed) {
                    this.altPressed(keyEvent, component, jRootPane, jMenuBar);
                }
                altKeyPressed = true;
                return true;
            }
            if (keyEvent.getID() == 402) {
                if (altKeyPressed) {
                    this.altReleased(keyEvent, component, jRootPane, jMenuBar);
                }
                altKeyPressed = false;
            }
        } else {
            altKeyPressed = false;
        }
        return false;
    }

    static void resetWinMetaKey() {
        winKeyArmed = false;
    }

    private void winMetaKeySupport(KeyEvent keyEvent) {
        Object object;
        RootPaneUI rootPaneUI;
        JFrame jFrame;
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isMetaDown();
        boolean bl2 = keyEvent.isControlDown();
        Window window = FocusManager.getCurrentManager().getActiveWindow();
        JFrame jFrame2 = jFrame = window instanceof JFrame ? (JFrame)window : null;
        if (n == 70 && bl && bl2 && keyEvent.getID() == 401 && jFrame != null && jFrame.isResizable() && SyntheticaTitlePane.isFullScreenOnMacSupported(jFrame) && (rootPaneUI = jFrame.getRootPane().getUI()) instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)rootPaneUI).getTitlePane() instanceof SyntheticaTitlePane) {
            object = (SyntheticaTitlePane)((SyntheticaRootPaneUI)rootPaneUI).getTitlePane();
            if (this.isMaximized(window)) {
                ((SyntheticaTitlePane)object).restore();
            } else {
                ((SyntheticaTitlePane)object).maximize();
            }
        }
        if (n == 524 && keyEvent.getID() == 401) {
            winKeyArmed = true;
        } else if (!winKeyArmed || n != 38) {
            if (bl && n == 38 && !this.isMaximized(window) && jFrame != null) {
                rootPaneUI = jFrame.getRootPane().getUI();
                if (rootPaneUI instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)rootPaneUI).isSnapEnabled(window) && ((SyntheticaRootPaneUI)rootPaneUI).getTitlePane() instanceof SyntheticaTitlePane) {
                    ((SyntheticaTitlePane)((SyntheticaRootPaneUI)rootPaneUI).getTitlePane()).maximize();
                }
            } else if ((winKeyArmed || bl) && n == 40 && this.isMaximized(window) && jFrame != null) {
                rootPaneUI = jFrame.getRootPane().getUI();
                if (rootPaneUI instanceof SyntheticaRootPaneUI) {
                    object = (SyntheticaRootPaneUI)rootPaneUI;
                    if (this.isMaximized(window) && ((SyntheticaRootPaneUI)object).getTitlePane() instanceof SyntheticaTitlePane) {
                        ((SyntheticaTitlePane)((SyntheticaRootPaneUI)object).getTitlePane()).restore();
                        ((SyntheticaRootPaneUI)object).restoreSnappedWindow(window, window.getGraphicsConfiguration(), true);
                    }
                }
            } else if (!winKeyArmed || n != 40) {
                if (bl && n == 40 && !this.isMaximized(window) && jFrame != null) {
                    rootPaneUI = jFrame.getRootPane().getUI();
                    if (rootPaneUI instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)rootPaneUI).isSnapEnabled(window) && ((SyntheticaRootPaneUI)rootPaneUI).getTitlePane() instanceof SyntheticaTitlePane) {
                        ((SyntheticaTitlePane)((SyntheticaRootPaneUI)rootPaneUI).getTitlePane()).iconify();
                    }
                } else if (!(!winKeyArmed && !bl || n != 37 && n != 39 || bl2 || jFrame == null)) {
                    rootPaneUI = jFrame.getRootPane().getUI();
                    if (rootPaneUI instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)rootPaneUI).isSnapEnabled(window)) {
                        if (n == 37) {
                            ((SyntheticaRootPaneUI)rootPaneUI).snapPrev(window);
                        } else {
                            ((SyntheticaRootPaneUI)rootPaneUI).snapNext(window);
                        }
                    }
                } else {
                    winKeyArmed = false;
                }
            }
        }
    }

    private boolean isMaximized(Window window) {
        return window instanceof Frame && (((Frame)window).getExtendedState() & 6) == 6;
    }

    private void altPressed(KeyEvent keyEvent, Component component, JRootPane jRootPane, JMenuBar jMenuBar) {
        if (UIManager.get("Button.showMnemonics") == null && !(component instanceof JMenuBar) && jRootPane != null) {
            jRootPane.repaint();
        }
        this.altPressed(keyEvent, jMenuBar);
    }

    private void altPressed(KeyEvent keyEvent, JMenuBar jMenuBar) {
        boolean bl = UIManager.getBoolean("Synthetica.forcedAltKeyEventConsumption");
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        if (menuElementArray.length > 0) {
            if (!(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
            }
            menuActivated = false;
            if (!bl) {
                keyEvent.consume();
            }
        } else {
            if (jMenuBar != null) {
                menuActivated = true;
            }
            if (jMenuBar != null && jMenuBar.getMenu(0) != null && !bl) {
                keyEvent.consume();
            }
        }
        if (bl) {
            keyEvent.consume();
        }
        if (jMenuBar != null && menuActivated) {
            jMenuBar.repaint();
        }
    }

    public static void setMenuActive(boolean bl) {
        menuActivated = bl;
    }

    public static boolean isMenuActive() {
        return menuActivated;
    }

    public static boolean isAltKeyPressed() {
        return altKeyPressed;
    }

    public static boolean showMnemonicsOnAltKeyOnly() {
        if (OS.getCurrentOS() == OS.Windows && SyntheticaLookAndFeel.getBoolean("Synthetica.showMnemonicsOnAltKeyOnly", null, true)) {
            return true;
        }
        return SyntheticaLookAndFeel.getBoolean("Synthetica.forceShowMnemonicsOnAltKeyOnly", null);
    }

    public static boolean activateMenuByAltKey() {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.activateMenuByAltKey", null, true);
    }

    private void altReleased(KeyEvent keyEvent, Component component, JRootPane jRootPane, JMenuBar jMenuBar) {
        if (UIManager.get("Button.showMnemonics") == null && !(component instanceof JMenuBar) && jRootPane != null) {
            jRootPane.repaint();
        }
        this.altReleased(keyEvent, jMenuBar);
    }

    private void altReleased(KeyEvent keyEvent, JMenuBar jMenuBar) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (menuSelectionManager.getSelectedPath().length == 0 && menuActivated) {
            JMenu jMenu;
            JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }
}

