/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableImage;
import de.javasoft.plaf.synthetica.SyntheticaIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ScalableIcon
extends SyntheticaIcon
implements Scalable {
    private Icon icon;
    private BaseMultiResolutionImage multiResImage;
    private static HashMap<Icon, Image> iconCache = new HashMap();
    private static boolean iconCacheEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.scalableIcon.iconCache.enabled", null, true);
    private static HashMap<Integer, Image> imageCache = new HashMap();
    private static boolean imageCacheEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.scalableIcon.imageCache.enabled", null, true);
    static int counter;

    public ScalableIcon(Class<?> clazz, String ... stringArray) {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                URL uRL = clazz.getResource(string);
                if (uRL == null) {
                    throw new RuntimeException("File not found: " + string);
                }
                arrayList.add(ImageIO.read(uRL));
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.multiResImage = new BaseMultiResolutionImage(arrayList.toArray(new Image[arrayList.size()]));
    }

    public ScalableIcon(Image ... imageArray) {
        this.multiResImage = new BaseMultiResolutionImage(imageArray);
    }

    public ScalableIcon(ScalableImage scalableImage) {
        this.multiResImage = scalableImage;
    }

    public ScalableIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    protected float getScaleFactor() {
        return SyntheticaLookAndFeel.getInstance().getScaleFactor();
    }

    @Override
    public int getIconHeight() {
        if (this.icon != null) {
            if (this.icon instanceof Scalable) {
                return this.icon.getIconHeight();
            }
            return (int)((float)this.icon.getIconHeight() * this.getScaleFactor());
        }
        if (this.multiResImage != null) {
            return (int)((float)this.multiResImage.getHeight(null) * this.getScaleFactor());
        }
        return 0;
    }

    @Override
    public int getIconHeight(SynthContext synthContext) {
        return this.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.icon != null) {
            if (this.icon instanceof Scalable) {
                return this.icon.getIconWidth();
            }
            return (int)((float)this.icon.getIconWidth() * this.getScaleFactor());
        }
        if (this.multiResImage != null) {
            return (int)((float)this.multiResImage.getWidth(null) * this.getScaleFactor());
        }
        return 0;
    }

    @Override
    public int getIconWidth(SynthContext synthContext) {
        return this.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        SynthContext synthContext = null;
        if (component instanceof AbstractButton && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            AbstractButton abstractButton = (AbstractButton)component;
            SynthStyle synthStyle = SyntheticaLookAndFeel.getStyle(abstractButton, Region.BUTTON);
            int n3 = 0;
            n3 |= abstractButton.getModel().isPressed() ? 4 : 0;
            n3 |= abstractButton.getModel().isSelected() ? 512 : 0;
            n3 |= !abstractButton.getModel().isEnabled() ? 8 : 0;
            synthContext = new SynthContext(abstractButton, Region.BUTTON, synthStyle, n3 |= abstractButton.getModel().isRollover() ? 2 : 0);
        }
        this.paintIcon(synthContext, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Image image = null;
        if (this.icon != null) {
            if (this.icon instanceof Scalable) {
                this.icon.paintIcon(synthContext.getComponent(), graphics, n, n2);
                return;
            }
            image = iconCache.get(this.icon);
            if (image == null) {
                image = GraphicsUtils.iconToImage(synthContext, this.icon);
                if (iconCacheEnabled) {
                    iconCache.put(this.icon, image);
                }
            }
        } else if (this.multiResImage != null) {
            image = this.multiResImage.getResolutionVariant(n3, n4);
        }
        if (SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f && image != null) {
            int n5 = image.hashCode();
            n5 = 31 * n5 + n3;
            Image image2 = imageCache.get(n5 = 31 * n5 + n4);
            if (image2 == null) {
                image = HiDpi.scaleImage(image, n3, n4);
                if (imageCacheEnabled) {
                    imageCache.put(n5, image);
                }
            } else {
                image = image2;
            }
        }
        if (image != null) {
            graphics.drawImage(image, n, n2, n3, n4, null);
        } else {
            graphics.setColor(Color.RED);
            graphics.drawLine(n, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n, n2 + n4 - 1);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    public static void reinitialize() {
        iconCache.clear();
        imageCache.clear();
    }

    public static class ScalableIconUIResource
    extends ScalableIcon
    implements UIResource {
        public ScalableIconUIResource(Class<?> clazz, String ... stringArray) {
            super(clazz, stringArray);
        }

        public ScalableIconUIResource(Image ... imageArray) {
            super(imageArray);
        }

        public ScalableIconUIResource(Icon icon) {
            super(icon);
        }
    }
}

