/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class ScalableImage
extends BaseMultiResolutionImage
implements Scalable {
    public ScalableImage(Class<?> clazz, String ... stringArray) {
        super(ScalableImage.getImageArray(clazz, stringArray));
    }

    private static Image[] getImageArray(Class<?> clazz, String ... stringArray) {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                URL uRL = clazz.getResource(string);
                if (uRL == null) {
                    throw new RuntimeException("File not found: " + string);
                }
                arrayList.add(ImageIO.read(uRL));
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList.toArray(new Image[arrayList.size()]);
    }

    public ScalableImage(Image ... imageArray) {
        super(imageArray);
    }

    protected float getScaleFactor() {
        SyntheticaLookAndFeel syntheticaLookAndFeel = SyntheticaLookAndFeel.getInstance();
        return syntheticaLookAndFeel == null ? (float)SyntheticaLookAndFeel.getInt("Synthetica.scaleFactor", null, 100, false) / 100.0f : syntheticaLookAndFeel.getScaleFactor();
    }

    public int getScaledWidth() {
        return (int)((float)this.getWidth(null) * this.getScaleFactor());
    }

    public int getScaledHeight() {
        return (int)((float)this.getHeight(null) * this.getScaleFactor());
    }

    public Image getScaledInstance() {
        int n = this.getScaledWidth();
        int n2 = this.getScaledHeight();
        Image image = this.getResolutionVariant(n, n2);
        return HiDpi.scaleImage(image, n, n2);
    }
}

