/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthSliderUI;

public class SyntheticaSliderUI
extends SynthSliderUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaSliderUI((JSlider)jComponent);
    }

    protected SyntheticaSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
        if (this.focusInsets == null) {
            this.focusInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(new Insets(0, 0, 0, 0));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        int n = 200;
        int n2 = SyntheticaLookAndFeel.getInstance().scaleInteger(n);
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (this.slider.getOrientation() == 0) {
            n3 = dimension.width - n + n2;
            n4 += SyntheticaLookAndFeel.getInstance().scaleInteger(4) - 4;
        } else {
            n3 += SyntheticaLookAndFeel.getInstance().scaleInteger(4) - 4;
            n4 = dimension.height - n + n2;
        }
        return new Dimension(n3, n4);
    }

    @Override
    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
        super.calculateGeometry();
        Insets insets = this.slider.getInsets();
        float f = SyntheticaLookAndFeel.getInstance().getScaleFactor();
        float f2 = Math.max(0.0f, f - 1.0f);
        if (this.slider.getOrientation() == 0) {
            int n = Math.round((float)insets.top / f);
            int n2 = n + 2;
            this.tickRect.y = (int)((float)this.tickRect.y + (float)n * f2);
            this.labelRect.y = (int)((float)this.labelRect.y + (float)n2 * f2);
            this.contentRect.height = (int)((float)this.contentRect.height + (float)n * f2);
        } else {
            int n = Math.round((float)insets.left / f);
            int n3 = n + 2;
            this.tickRect.x = (int)((float)this.tickRect.x + (float)n * f2);
            this.labelRect.x = (int)((float)this.labelRect.x + (float)n3 * f2);
            this.contentRect.width = (int)((float)this.contentRect.width + (float)n * f2);
        }
    }

    @Override
    protected int getTickLength() {
        return SyntheticaLookAndFeel.getInt("Synthetica.slider.tickLength", this.slider, 8, true);
    }

    @Override
    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(synthContext, graphics);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        graphics.fillRect(n, 0, n2, rectangle.height / 2);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        graphics.fillRect(n, 0, n2, rectangle.height - n2);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        graphics.fillRect(0, n, rectangle.width / 2, n2);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        graphics.fillRect(0, n, rectangle.width - n2, n2);
    }
}

