/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.BakedArrayList;
import sun.swing.plaf.synth.DefaultSynthStyle;
import sun.swing.plaf.synth.StyleAssociation;

class SyntheticaStyleFactory {
    public static final int NAME = 0;
    public static final int REGION = 1;
    private List<StyleAssociation> styles;
    private BakedArrayList<Object> tmpList;
    private Map<BakedArrayList<Object>, SynthStyle> resolvedStyles;
    private SynthStyle defaultStyle;

    SyntheticaStyleFactory(SynthStyleFactory synthStyleFactory) {
        try {
            Class<?> clazz = Class.forName("javax.swing.plaf.synth.DefaultSynthStyleFactory");
            Field field = clazz.getDeclaredField("_styles");
            field.setAccessible(true);
            this.styles = (List)field.get(synthStyleFactory);
            Field field2 = clazz.getDeclaredField("_tmpList");
            field2.setAccessible(true);
            this.tmpList = (BakedArrayList)field2.get(synthStyleFactory);
            Field field3 = clazz.getDeclaredField("_resolvedStyles");
            field3.setAccessible(true);
            this.resolvedStyles = (Map)field3.get(synthStyleFactory);
            Field field4 = clazz.getDeclaredField("_defaultStyle");
            field4.setAccessible(true);
            this.defaultStyle = (SynthStyle)field4.get(synthStyleFactory);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized SynthStyle getStyle(JComponent jComponent, Region region) {
        SynthStyle synthStyle;
        BakedArrayList<Object> bakedArrayList = this.tmpList;
        bakedArrayList.clear();
        this.getMatchingStyles(bakedArrayList, this.styles, jComponent, region);
        if (bakedArrayList.size() == 0) {
            if (this.defaultStyle == null) {
                this.defaultStyle = new DefaultSynthStyle();
                ((DefaultSynthStyle)this.defaultStyle).setFont(new FontUIResource("Dialog", 0, 12));
            }
            return this.defaultStyle;
        }
        bakedArrayList.cacheHashCode();
        SynthStyle synthStyle2 = synthStyle = bakedArrayList.size() == 0 ? null : this.resolvedStyles.get(bakedArrayList);
        if (synthStyle == null && (synthStyle = this.mergeStyles(bakedArrayList)) != null) {
            this.resolvedStyles.put(new BakedArrayList<Object>((List<Object>)bakedArrayList), synthStyle);
        }
        return synthStyle;
    }

    private void getMatchingStyles(List<Object> list, List<StyleAssociation> list2, JComponent jComponent, Region region) {
        String string = region.getName().toLowerCase(Locale.ENGLISH);
        String string2 = SyntheticaLookAndFeel.getStyleName(jComponent);
        if (string2 == null) {
            string2 = "";
        }
        int n = list2.size() - 1;
        while (n >= 0) {
            String string3;
            StyleAssociation styleAssociation = list2.get(n);
            String string4 = string3 = styleAssociation.getID() == 0 ? string2 : string;
            if (styleAssociation.matches(string3) && list.indexOf(styleAssociation.getStyle()) == -1) {
                list.add(styleAssociation.getStyle());
            }
            --n;
        }
    }

    private SynthStyle mergeStyles(BakedArrayList<Object> bakedArrayList) {
        int n = bakedArrayList.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (SynthStyle)((DefaultSynthStyle)bakedArrayList.get(0)).clone();
        }
        DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)bakedArrayList.get(n - 1);
        defaultSynthStyle = (DefaultSynthStyle)defaultSynthStyle.clone();
        int n2 = n - 2;
        while (n2 >= 0) {
            defaultSynthStyle = ((DefaultSynthStyle)bakedArrayList.get(n2)).addTo(defaultSynthStyle);
            --n2;
        }
        return defaultSynthStyle;
    }
}

