/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class FormattedTextFieldStyle
extends StyleWrapper {
    private static FormattedTextFieldStyle instance = new FormattedTextFieldStyle();

    private FormattedTextFieldStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null && ((JTextComponent)jComponent).isEditable()) {
            instance.setStyle(synthStyle);
            return instance;
        }
        FormattedTextFieldStyle formattedTextFieldStyle = new FormattedTextFieldStyle();
        formattedTextFieldStyle.setStyle(synthStyle);
        return formattedTextFieldStyle;
    }

    @Override
    public Insets getInsets(SynthContext synthContext, Insets insets) {
        Insets insets2 = this.synthStyle.getInsets(synthContext, insets);
        String string = synthContext.getComponent().getName();
        if ("Spinner.formattedTextField".equals(string)) {
            insets2 = synthContext.getComponent().getComponentOrientation().isLeftToRight() ? new Insets(0, 0, 0, insets2.right) : new Insets(0, insets2.right, 0, 0);
        } else if ("ComboBox.textField".equals(string)) {
            insets2 = new Insets(0, 1, 0, 1);
        }
        return SyntheticaLookAndFeel.getInstance().scaleInsets(insets2);
    }

    @Override
    public Color getColorForState(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        if (colorType == ColorType.TEXT_FOREGROUND && jComponent.getForeground() instanceof ColorUIResource && !((JTextComponent)jComponent).isEditable()) {
            Color color = SyntheticaLookAndFeel.getColor("Synthetica.formattedTextField.locked.textColor", jComponent);
            return color == null ? super.getColorForState(synthContext, colorType) : color;
        }
        return super.getColorForState(synthContext, colorType);
    }
}

