/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableFont;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public abstract class StyleWrapper
extends SynthStyle {
    private static Map<Icon, ScalableIcon.ScalableIconUIResource> iconCache = new HashMap<Icon, ScalableIcon.ScalableIconUIResource>();
    protected SynthStyle synthStyle;

    public StyleWrapper() {
    }

    public StyleWrapper(SynthStyle synthStyle) {
        this.synthStyle = synthStyle;
    }

    public static void reinitialize() {
        iconCache.clear();
    }

    void setStyle(SynthStyle synthStyle) {
        this.synthStyle = synthStyle;
    }

    public SynthStyle getStyle() {
        return this.synthStyle;
    }

    @Override
    public Object get(SynthContext synthContext, Object object) {
        return this.synthStyle.get(synthContext, object);
    }

    @Override
    public boolean getBoolean(SynthContext synthContext, Object object, boolean bl) {
        return this.synthStyle.getBoolean(synthContext, object, bl);
    }

    @Override
    public Color getColor(SynthContext synthContext, ColorType colorType) {
        return this.synthStyle.getColor(synthContext, colorType);
    }

    @Override
    public Color getColorForState(SynthContext synthContext, ColorType colorType) {
        return this.synthStyle.getColor(synthContext, colorType);
    }

    @Override
    public Font getFont(SynthContext synthContext) {
        Font font = this.synthStyle.getFont(synthContext);
        if (!this.isSyntheticaFontEnabled(synthContext) && font != null && !(font instanceof Scalable)) {
            font = new ScalableFont(font.deriveFont(font.getStyle(), SyntheticaLookAndFeel.getInstance().scaleFontSize(font.getSize())));
        }
        return font;
    }

    @Override
    public Font getFontForState(SynthContext synthContext) {
        return this.getFont(synthContext);
    }

    @Override
    public SynthGraphicsUtils getGraphicsUtils(SynthContext synthContext) {
        return this.synthStyle.getGraphicsUtils(synthContext);
    }

    @Override
    public Icon getIcon(SynthContext synthContext, Object object) {
        Icon icon = this.synthStyle.getIcon(synthContext, object);
        if (icon == null || icon instanceof Scalable || !SyntheticaLookAndFeel.getInstance().isUIScalingEnabled()) {
            return icon;
        }
        ScalableIcon.ScalableIconUIResource scalableIconUIResource = iconCache.get(icon);
        if (scalableIconUIResource == null) {
            Icon icon2 = this.synthStyle.getIcon(synthContext, object + SyntheticaLookAndFeel.getInstance().getScaleKeyExtension());
            scalableIconUIResource = icon2 == null ? new ScalableIcon.ScalableIconUIResource(icon) : new ScalableIcon.ScalableIconUIResource(GraphicsUtils.iconToImage(synthContext, icon), GraphicsUtils.iconToImage(synthContext, icon2));
            iconCache.put(icon, scalableIconUIResource);
        }
        return scalableIconUIResource;
    }

    @Override
    public Insets getInsets(SynthContext synthContext, Insets insets) {
        Insets insets2 = this.synthStyle.getInsets(synthContext, insets);
        return insets2 == null ? null : SyntheticaLookAndFeel.getInstance().scaleInsets(insets2);
    }

    @Override
    public int getInt(SynthContext synthContext, Object object, int n) {
        Object object2 = this.synthStyle.get(synthContext, object);
        if (object2 instanceof Number) {
            int n2 = ((Number)object2).intValue();
            return n2 == 0 ? n2 : SyntheticaLookAndFeel.getInstance().scaleInteger(n2);
        }
        return n;
    }

    @Override
    public SynthPainter getPainter(SynthContext synthContext) {
        return SyntheticaPainter.getInstance();
    }

    @Override
    public String getString(SynthContext synthContext, Object object, String string) {
        return this.synthStyle.getString(synthContext, object, string);
    }

    @Override
    public void installDefaults(SynthContext synthContext) {
        JComponent jComponent;
        Font font;
        this.synthStyle.installDefaults(synthContext);
        if (!this.isSyntheticaFontEnabled(synthContext) && ((font = (jComponent = synthContext.getComponent()).getFont()) == null || font instanceof UIResource)) {
            jComponent.setFont(this.getFontForState(synthContext));
        }
    }

    @Override
    public boolean isOpaque(SynthContext synthContext) {
        return this.synthStyle.isOpaque(synthContext);
    }

    @Override
    public void uninstallDefaults(SynthContext synthContext) {
        this.synthStyle.uninstallDefaults(synthContext);
    }

    private boolean isSyntheticaFontEnabled(SynthContext synthContext) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.font.enabled", synthContext.getComponent(), true);
    }
}

