/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ToolBarButtonStyle
extends StyleWrapper {
    private static ToolBarButtonStyle instance = new ToolBarButtonStyle();

    private ToolBarButtonStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        ToolBarButtonStyle toolBarButtonStyle = new ToolBarButtonStyle();
        toolBarButtonStyle.setStyle(synthStyle);
        return toolBarButtonStyle;
    }

    @Override
    public Object get(SynthContext synthContext, Object object) {
        Object object2 = super.get(synthContext, object);
        if ("Button.margin".equals(object) && object2 != null) {
            object2 = SyntheticaLookAndFeel.getInstance().scaleInsets((Insets)object2);
        } else if ("Button.iconTextGap".equals(object) && object2 != null) {
            object2 = SyntheticaLookAndFeel.getInstance().scaleInteger((Integer)object2);
        }
        return object2;
    }

    @Override
    public Font getFont(SynthContext synthContext) {
        Font font = super.getFont(synthContext);
        JComponent jComponent = synthContext.getComponent();
        if (SyntheticaLookAndFeel.get("Synthetica.toolBar.button.font.style", jComponent) != null) {
            float f;
            int n = 0;
            String string = SyntheticaLookAndFeel.getString("Synthetica.toolBar.button.font.style", jComponent);
            if (string.contains("BOLD")) {
                n |= 1;
            }
            if (string.contains("ITALIC")) {
                n |= 2;
            }
            if ((f = SyntheticaLookAndFeel.getInstance().scaleFontSize(SyntheticaLookAndFeel.getInt("Synthetica.toolBar.button.font.size", (Component)jComponent, 0))) == 0.0f) {
                f = font.getSize2D();
            }
            font = new FontUIResource(font.deriveFont(n, f));
        } else if (SyntheticaLookAndFeel.get("Synthetica.toolBar.toggleButton.font.style", jComponent) != null) {
            float f;
            int n = 0;
            String string = SyntheticaLookAndFeel.getString("Synthetica.toolBar.toggleButton.font.style", jComponent);
            if (string.contains("BOLD")) {
                n |= 1;
            }
            if (string.contains("ITALIC")) {
                n |= 2;
            }
            if ((f = SyntheticaLookAndFeel.getInstance().scaleFontSize(SyntheticaLookAndFeel.getInt("Synthetica.toolBar.toggleButton.font.size", (Component)jComponent, 0))) == 0.0f) {
                f = font.getSize2D();
            }
            font = new FontUIResource(font.deriveFont(n, f));
        }
        return font;
    }
}

