/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.ColorBurnComposite;
import de.javasoft.plaf.synthetica.util.LinearLightComposite;
import de.javasoft.plaf.synthetica.util.LuminosityComposite;
import de.javasoft.plaf.synthetica.util.MultiplyComposite;
import de.javasoft.plaf.synthetica.util.OverlayComposite;
import de.javasoft.plaf.synthetica.util.SoftBurnComposite;
import de.javasoft.plaf.synthetica.util.SoftLightComposite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class Synthetica2DUtils {
    private static final String SYNTHETICA_DEFAULT_BLEND_MODE = "Synthetica.background.defaultBlendMode";

    public static BufferedImage createBlurredImage(BufferedImage bufferedImage, int n) {
        ConvolveOp convolveOp = Synthetica2DUtils.createBlurOp(n);
        BufferedImage bufferedImage2 = convolveOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        convolveOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static ConvolveOp createBlurOp(int n) {
        float[] fArray = new float[n * n];
        float f = 1.0f / (float)(n * n);
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = f;
            ++n2;
        }
        return new ConvolveOp(new Kernel(n, n, fArray));
    }

    public static BufferedImage createAlphaImage(BufferedImage bufferedImage, float f) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createColorizedImage(BufferedImage bufferedImage, Color color, float f) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Synthetica2DUtils.colorizeImage(bufferedImage, bufferedImage2, color, f);
        return bufferedImage2;
    }

    public static void colorizeImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, Color color, float f) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(10, f));
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.dispose();
    }

    public static BufferedImage createColorizedImage(BufferedImage bufferedImage, Color color, String string) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Synthetica2DUtils.colorizeImage(bufferedImage, bufferedImage2, color, string);
        return bufferedImage2;
    }

    public static void colorizeImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, Color color, String string) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        if (string == null || BlendMode.MULTIPLY.toString().equals(string)) {
            graphics2D.setComposite(MultiplyComposite.Multiply);
        } else if (BlendMode.COLOR_BURN.toString().equals(string)) {
            graphics2D.setComposite(ColorBurnComposite.ColorBurn);
        } else if (BlendMode.LUMINOSITY.toString().equals(string)) {
            graphics2D.setComposite(LuminosityComposite.Luminosity);
        } else if (BlendMode.OVERLAY.toString().equals(string)) {
            graphics2D.setComposite(OverlayComposite.Overlay);
        } else if (BlendMode.SOFT_BURN.toString().equals(string)) {
            graphics2D.setComposite(SoftBurnComposite.SolftBurn);
        } else if (BlendMode.SOFT_LIGHT.toString().equals(string)) {
            graphics2D.setComposite(SoftLightComposite.SoftLight);
        } else if (BlendMode.LINEAR_LIGHT.toString().equals(string)) {
            graphics2D.setComposite(LinearLightComposite.LinearLight);
        }
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.dispose();
    }

    public static Image flipHorizontal(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.scale(-1.0, 1.0);
        graphics2D.translate(-image.getWidth(null), 0);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image flipVertical(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.scale(1.0, -1.0);
        graphics2D.translate(0, -image.getHeight(null));
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Color blend(Color color, Color color2, BlendMode blendMode) {
        int n = 0;
        if (blendMode == null) {
            if (color2.getAlpha() == 255) {
                BlendMode blendMode2 = BlendMode.valueOf(SyntheticaLookAndFeel.getString(SYNTHETICA_DEFAULT_BLEND_MODE, null, BlendMode.MULTIPLY.toString()));
                n = Synthetica2DUtils.blend(color, color2, blendMode2).getRGB();
            } else {
                n = Synthetica2DUtils.alphaBlend(color.getRGB(), color2.getRGB());
            }
        } else if (blendMode == BlendMode.ALPHA) {
            n = Synthetica2DUtils.alphaBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.COLOR_BURN) {
            n = Synthetica2DUtils.colorBurnBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.LUMINOSITY) {
            n = Synthetica2DUtils.luminosityBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.MULTIPLY) {
            n = Synthetica2DUtils.multiplyBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.OVERLAY) {
            n = Synthetica2DUtils.overlayBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.SOFT_BURN) {
            n = Synthetica2DUtils.softBurnBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.SOFT_LIGHT) {
            n = Synthetica2DUtils.softLightBlend(color.getRGB(), color2.getRGB());
        } else if (blendMode == BlendMode.LINEAR_LIGHT) {
            n = Synthetica2DUtils.linearLightBlend(color.getRGB(), color2.getRGB());
        }
        return new Color(n);
    }

    private static int luminosityBlend(int n, int n2) {
        return LuminosityComposite.luminostyRGB(n, n2);
    }

    private static int multiplyBlend(int n, int n2) {
        return MultiplyComposite.multiplyRGB(n, n2);
    }

    private static int alphaBlend(int n, int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = (n5 * n3 + n4 * (255 - n3)) / 255;
        int n7 = n >> 8 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = (n8 * n3 + n7 * (255 - n3)) / 255;
        int n10 = n >> 16 & 0xFF;
        int n11 = n2 >> 16 & 0xFF;
        int n12 = (n11 * n3 + n10 * (255 - n3)) / 255;
        return n6 | n9 << 8 | n12 << 16 | 0xFF000000;
    }

    private static int colorBurnBlend(int n, int n2) {
        return ColorBurnComposite.colorBurnRGB(n2, n);
    }

    private static int overlayBlend(int n, int n2) {
        return OverlayComposite.overlayRGB(n2, n);
    }

    private static int softBurnBlend(int n, int n2) {
        return SoftBurnComposite.softBurnRGB(n2, n);
    }

    private static int softLightBlend(int n, int n2) {
        return SoftLightComposite.softLightRGB(n2, n);
    }

    private static int linearLightBlend(int n, int n2) {
        return LinearLightComposite.linearLightRGB(n2, n);
    }

    public static float[] RGBtoHSL(int n, int n2, int n3) {
        float f;
        float f2;
        float f3;
        float f4;
        float[] fArray = new float[3];
        float f5 = (float)n / 255.0f;
        float f6 = (float)n2 / 255.0f;
        float f7 = (float)n3 / 255.0f;
        if (f5 > f6) {
            f4 = f6;
            f3 = f5;
        } else {
            f4 = f5;
            f3 = f6;
        }
        if (f7 > f3) {
            f3 = f7;
        }
        if (f7 < f4) {
            f4 = f7;
        }
        float f8 = f3 - f4;
        float f9 = (f3 + f4) / 2.0f;
        if (f8 - 0.01f <= 0.0f) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            f = f9 < 0.5f ? f8 / (f3 + f4) : f8 / (2.0f - f3 - f4);
            float f10 = ((f3 - f5) / 6.0f + f8 / 2.0f) / f8;
            float f11 = ((f3 - f6) / 6.0f + f8 / 2.0f) / f8;
            float f12 = ((f3 - f7) / 6.0f + f8 / 2.0f) / f8;
            f2 = f5 == f3 ? f12 - f11 : (f6 == f3 ? 0.33333334f + f10 - f12 : 0.6666667f + f11 - f10);
            if (f2 < 0.0f) {
                f2 += 1.0f;
            }
            if (f2 > 1.0f) {
                f2 -= 1.0f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f;
        fArray[2] = f9;
        return fArray;
    }

    public static int[] HSLtoRGB(float f, float f2, float f3) {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[3];
        if (f2 - 0.01f <= 0.0f) {
            n3 = (int)(f3 * 255.0f);
            n2 = (int)(f3 * 255.0f);
            n = (int)(f3 * 255.0f);
        } else {
            float f4 = f3 < 0.5f ? f3 * (1.0f + f2) : f3 + f2 - f2 * f3;
            float f5 = 2.0f * f3 - f4;
            n3 = (int)(255.0f * Synthetica2DUtils.hue2RGB(f5, f4, f + 0.33333334f));
            n2 = (int)(255.0f * Synthetica2DUtils.hue2RGB(f5, f4, f));
            n = (int)(255.0f * Synthetica2DUtils.hue2RGB(f5, f4, f - 0.33333334f));
        }
        nArray[0] = n3;
        nArray[1] = n2;
        nArray[2] = n;
        return nArray;
    }

    private static float hue2RGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }

    public static int rgb2lum(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return Math.min(255, (int)((float)n2 * 0.11f + (float)n3 * 0.59f + (float)n4 * 0.3f));
    }

    public static enum BlendMode {
        ALPHA,
        COLOR_BURN,
        LUMINOSITY,
        MULTIPLY,
        OVERLAY,
        SOFT_BURN,
        SOFT_LIGHT,
        LINEAR_LIGHT;

    }
}

