import java.awt.*;
import java.awt.event.*;
import java.beans.*;

import gnu.io.*;
import java.io.*;

import com.topaz.sigplus.*;

public class SigGemColor57Demo extends Frame implements Runnable
   {
   SigPlus              sigObj = null;
   static final int     numImages = 4;
   Image[]              rawImages;

   static final String  fileBase = ".\\";
   Thread               eventThread;
   String		signature;
   String		padVal="";
	
   public static void main(String Args[])
      {
      SigGemColor57Demo demo = new SigGemColor57Demo();
      }

   public SigGemColor57Demo()
      {
      int      i;
      String   fileName;


      try
         {

              ClassLoader cl = (com.topaz.sigplus.SigPlus.class).getClassLoader();
	      sigObj = (SigPlus)Beans.instantiate(cl, "com.topaz.sigplus.SigPlus");

	      setLayout(new GridLayout(1,1));
  	      add( sigObj );
	      pack();
  	      setTitle("Topaz SigGem Color 5.7 Demo");


         addWindowListener(new WindowAdapter()
            {
            public void windowClosing(WindowEvent we)
               {
                  try{
                  //reset hardware to default settings
                  sigObj.lcdRefresh(0, 0, 0, 640, 480);
                  sigObj.keyPadClearHotSpotList();
                  sigObj.keyPadSetSigWindow(1, 0, 0, 640, 480);
                  sigObj.lcdSetWindow(0, 0, 640, 480);
                  sigObj.lcdWriteImage(1, 0, 0, 0, 640, 480, rawImages[0], 0); //clear background memory
                  sigObj.setLCDCaptureMode(1);
                  sigObj.setTabletState(0);
                  System.exit(0);
                  }
                  catch(Exception e)
                  {
                     //let it go
                  }
               }

            public void windowClosed(WindowEvent we)
               {
                  System.exit(0);
               }
	    });


         sigObj.addSigPlusListener(new SigPlusListener()
            {
            public void handleTabletTimerEvent(SigPlusEvent0 evt)
               {
               }

            public void handleNewTabletData(SigPlusEvent0 evt)
               {
               }


            public void handleKeyPadData(SigPlusEvent0 evt)
               {
               }
	    });


         setSize(640, 256);
         show();

         sigObj.setTabletModel("SigGemColor57");
  	 sigObj.setTabletComPort("HID1");
  	 sigObj.setTabletBaudRate(115200);
         sigObj.setLCDTabletMap(1, 640, 480, 100, 100, 1970, 1500, 1, 127, 127, 1);


         //check for pad connectivity
	 sigObj.setTabletComTest(true);
	 sigObj.setTabletState(1);

         if(sigObj.getTabletState()==0)
         {
            sigObj.setTabletComTest(false);
            System.out.println("Cannot locate signature pad...exiting");
            System.exit(0);
         }
      

         sigObj.setTabletComTest(false);
         sigObj.setLCDCaptureMode(2);

         sigObj.keyPadSetSigWindow(1, 0, 0, 1, 1);
         sigObj.lcdSetWindow(0, 0, 1, 1);

         sigObj.keyPadAddHotSpot(0, 1, 20, 370, 450, 100); 

         MediaTracker mt = new MediaTracker(this);
         rawImages = new Image[ numImages ];
         String[] imageTitles = 
		{
			"topazlogoSM", 
			"clickhere",
                        "clearok",
                        "sign"
                };

	 for(i = 0; i < numImages; i++)
            {
               fileName = fileBase + imageTitles[i] + ".jpg";
               rawImages[ i ] = Toolkit.getDefaultToolkit().getImage(fileName);
               mt.addImage(rawImages[ i ], i + 1);
            }
         try
            {
               mt.waitForAll();
            }
         catch(Exception e)
            {
               System.out.println("Error opening image files");
            }

         sigObj.lcdRefresh(0, 0, 0, 640, 480);


	 sigObj.setLCDPixelDepth(8);
	 sigObj.lcdWriteImage(1, 2, 80, 140, 451, 183, rawImages[0], 3);

         sigObj.setLCDPixelDepth(0);
	 sigObj.lcdWriteImage(1, 2, 20, 375, 374, 20, rawImages[1], 0);

	 sigObj.lcdRefresh(2, 0, 0, 640, 480);
	 sigObj.setLCDCaptureMode(2);

         
         eventThread = new Thread(this);
         eventThread.start();
         }
      catch (Exception e)
         {
         return;
         }
      }

   public void run()
      {
      try
	 {
	 while (true)
	    {
	    Thread.sleep(75);
            
            if(sigObj.keyPadQueryHotSpot(0) !=0)
               {
                     sigObj.keyPadClearSigWindow(1);
                     sigObj.lcdRefresh(1, 20, 370, 450, 100);
                     sigObj.lcdRefresh(0, 0, 0, 640, 480);
                     sigObj.keyPadClearHotSpotList();

                     sigObj.keyPadSetSigWindow(1, 0, 362, 640, 117);
                     sigObj.lcdSetWindow(0, 362, 640, 118);
   
	             sigObj.setLCDPixelDepth(0);
                     sigObj.lcdWriteImage(0, 2, 0, 306, 640, 20, rawImages[2], 0);

	             sigObj.setLCDPixelDepth(8);
	             sigObj.lcdWriteImage(0, 2, 1, 362, 639, 118, rawImages[3], 3);

                     sigObj.keyPadAddHotSpot(1, 1, 20, 300, 150, 40);
                     sigObj.keyPadAddHotSpot(2, 1, 400, 300, 60, 40);
               }

 

            if(sigObj.keyPadQueryHotSpot(1) !=0)
               {
                     sigObj.keyPadClearSigWindow(1);
                     sigObj.lcdRefresh(1, 20, 300, 150, 40);
                     sigObj.clearTablet();

	             sigObj.setLCDPixelDepth(8);
	             sigObj.lcdWriteImage(0, 2, 1, 362, 639, 118, rawImages[3], 3);
                     sigObj.lcdRefresh(1, 20, 300, 150, 40);
               }


            if(sigObj.keyPadQueryHotSpot(2) !=0)
               {
                     sigObj.keyPadClearSigWindow(1);
                     sigObj.lcdRefresh(1, 400, 300, 60, 40);
                     sigObj.lcdRefresh(1, 400, 300, 60, 40);

                     if(sigObj.numberOfTabletPoints() > 0)
                     {
                        sigObj.setSigCompressionMode(1);
                        //this routine will bind the signature to the specified data
                        //in a real-world application, you should bind the signature to
                        //the pertinent data to which the signer is reading and agreeing
                        //for this demo, we will bind to sample data instead

      			sigObj.autoKeyStart(); //start binding process
      			sigObj.setAutoKeyData("Here is some sample binding data");
      			sigObj.setAutoKeyData("I can add as much as I want");
      			sigObj.autoKeyFinish(); //tell SigPlus you are done passing in data
      			sigObj.setEncryptionMode(2); //finish binding process...you can now get SigString
                        System.out.println("Signature captured...here is SigString: " + sigObj.getSigString());
                        //store this SigString away for later use, as needed

                        //clear out signature and re-start demo app

                        sigObj.setEncryptionMode(0);
      			sigObj.setKeyString("0000000000000000");
      			sigObj.clearTablet();
      			sigObj.setLCDPixelDepth(0);
      			sigObj.keyPadClearHotSpotList();
      			sigObj.lcdRefresh(0, 0, 0, 640, 480);

                        startItUp();

                     }
                     else //otherwise, signer has not signed! Go back and make them sign before continuing
                     {
                        System.out.println("Please sign before continuing. No signature captured.");
                     }
              }
             sigObj.keyPadClearSigWindow(1);
             }
           }
      catch (InterruptedException e)
         {
	 }
      }

         public void startItUp()
         {
            sigObj.keyPadSetSigWindow(1, 0, 0, 1, 1);
            sigObj.lcdSetWindow(0, 0, 1, 1);
            sigObj.lcdRefresh(2, 0, 0, 640, 480);
            sigObj.keyPadClearHotSpotList();

            sigObj.keyPadAddHotSpot(0, 1, 20, 370, 450, 100);
            sigObj.setLCDCaptureMode(2);
         }


   }


